import Link from 'next/link';
import LogoBar from './LogoBar';

const PublicHeader = () => {
  return (
    <>
      <LogoBar />
      <nav className="bg-doctor-dark text-white relative">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="mx-auto py-3 flex items-center justify-center">
            <div className="flex flex-col md:flex-row md:space-x-10 md:space-y-0 space-y-5 items-center">
              <Link href="/" className="hover:text-doctor-light transition-colors duration-200">
                الرئيسية
              </Link>
              <Link href="/vision" className="hover:text-doctor-light transition-colors duration-200">
                الرؤية والرسالة
              </Link>
              <Link href="/about" className="hover:text-doctor-light transition-colors duration-200">
                من نحن
              </Link>
              <Link href="/media" className="hover:text-doctor-light transition-colors duration-200">
                الميديا
              </Link>
              <Link href="/testimonials" className="hover:text-doctor-light transition-colors duration-200">
                الآراء والتقييمات العامة
              </Link>
              <Link href="/faq" className="hover:text-doctor-light transition-colors duration-200">
                الأسئلة الشائعة
              </Link>
              <Link href="/contact" className="hover:text-doctor-light transition-colors duration-200">
                تواصل معنا
              </Link>
            </div>
          </div>
        </div>
      </nav>
    </>
  );
};

export default PublicHeader;
