/* eslint-disable @typescript-eslint/no-unused-vars */
import React from 'react';
import Link from 'next/link';
import Image from 'next/image';
import { ApiResponse } from '@/app/(private)/dashboard/user/user.schema'; // Adjust path

// Fetch public user details with ISR
async function fetchUserPublicDetails(): Promise<ApiResponse> {
  const response = await fetch(`${process.env.NEXT_PUBLIC_SERVER_URL}/user/me/public`, {
    next: { revalidate: 30 }, // Revalidate every 30 seconds
  });
  if (!response.ok) {
    throw new Error('Failed to fetch user public details');
  }
  return response.json();
}

export default async function LogoBar() {
  try {
    const userData = await fetchUserPublicDetails();
    const user = userData.data;
    const logoUrl = user.logo?.[0]?.url || '/logo.svg'; // Dynamic logo or fallback
    const userName = user.user_name || 'د. قايد العنزي'; // Dynamic name or fallback

    return (
      <header className="bg-doctor-dark text-gray-900 shadow-sm relative border-b-4 border-gray-200 py-2">
        <div className="max-w-[85rem] mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex justify-between items-center relative">
            <div className="absolute left-1/2 transform -translate-x-1/2">
              <h2 className="md:text-lg text-sm font-semibold text-gray-900 text-center">
                <span className="block text-white">علاج آلام العمود الفقري والمفاصل</span>
                <span className="block text-doctor-light">{userName}</span>
              </h2>
            </div>

            <div className="flex items-center bg-white rounded-full p-1 ml-auto">
              <Link href="/" className="flex items-center">
                <Image src={logoUrl} alt={`${userName} Logo`} height={400} width={400} className="md:w-20 md:h-20 w-12 h-12 object-contain" />
              </Link>
            </div>
          </div>
        </div>
      </header>
    );
  } catch (error) {
    // Fallback UI in case of fetch failure
    return (
      <header className="bg-doctor-dark text-gray-900 shadow-sm relative border-b-4 border-gray-200 py-2">
        <div className="max-w-[85rem] mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex justify-between items-center relative">
            <div className="absolute left-1/2 transform -translate-x-1/2">
              <h2 className="md:text-lg text-sm font-semibold text-gray-900 text-center">
                <span className="block text-white">علاج آلام العمود الفقري والمفاصل</span>
                <span className="block text-doctor-light">د. قايد العنزي</span>
              </h2>
            </div>

            <div className="flex items-center bg-white rounded-full p-1 ml-auto">
              <Link href="/" className="flex items-center">
                <Image src="/logo.svg" alt="Default Logo" height={400} width={400} className="md:w-20 md:h-20 w-12 h-12 object-contain" />
              </Link>
            </div>
          </div>
        </div>
      </header>
    );
  }
}
