'use client';

import React, { useEffect } from 'react';
import { FaFacebook, FaInstagram, FaYoutube, FaPhoneAlt, FaEnvelope, FaMapMarkerAlt } from 'react-icons/fa';
import Link from 'next/link';

const PublicFooter = () => {
  // Add fade-in animation effect on mount
  useEffect(() => {
    const footerElements = document.querySelectorAll('.footer-item');
    footerElements.forEach((element, index) => {
      element.classList.add('opacity-0');
      setTimeout(() => {
        element.classList.add('animate-fadeIn');
        element.classList.remove('opacity-0');
      }, index * 200); // Staggered animation with 200ms delay per item
    });
  }, []);

  return (
    <footer className="bg-doctor-dark text-white py-8">
      <div className="max-w-7xl mx-auto px-4 grid grid-cols-1 md:grid-cols-4 gap-8" dir="rtl">
        {/* Doctor Info */}
        <div className="footer-item">
          <div className="flex items-center mb-4">
            <span role="img" aria-label="stethoscope" className="text-2xl mr-2">
              🩺
            </span>
            <h3 className="text-xl font-bold text-white">د. قايد العنزي</h3>
          </div>
          <p className="text-gray-200">
            متخصص في الأشعة التداخلية بخبرة تزيد عن 15 عامًا، أقدم علاجات دقيقة وغير جراحية باستخدام أحدث التقنيات. هدفي هو تحسين جودة حياة مرضاي من خلال رعاية شخصية ومخصصة.
          </p>
        </div>

        {/* Support Links */}
        <div className="footer-item">
          <h4 className="text-lg font-semibold mb-4 text-white">الدعم</h4>
          <ul className="space-y-2">
            <li>
              <Link href="/about" className="hover:text-doctor-primary transition-colors">
                من نحن
              </Link>
            </li>
            <li>
              <Link href="/departments" className="hover:text-doctor-primary transition-colors">
                الأقسام الطبية
              </Link>
            </li>
            <li>
              <Link href="/contact" className="hover:text-doctor-primary transition-colors">
                تواصل معنا
              </Link>
            </li>
            <li>
              <Link href="/contact" className="hover:text-doctor-primary transition-colors">
                حجز استشارة
              </Link>
            </li>
          </ul>
        </div>

        {/* Treatments Links */}
        <div className="footer-item">
          <h4 className="text-lg font-semibold mb-4 text-white">المركز الاعلامي</h4>
          <ul className="space-y-2">
            <li>
              <Link href="/media/articles" className="hover:text-doctor-primary transition-colors">
                المقالات
              </Link>
            </li>
            <li>
              <Link href="/media/videos" className="hover:text-doctor-primary transition-colors">
                الفيديوهات
              </Link>
            </li>
            <li>
              <Link href="/media/faq" className="hover:text-doctor-primary transition-colors">
                الاسئلة الشائعة
              </Link>
            </li>
          </ul>
        </div>

        {/* Follow Us & Additional Contact */}
        <div className="footer-item">
          <h4 className="text-lg font-semibold mb-4 text-white">تابعني</h4>
          <div className="flex space-x-4 mb-4">
            <Link href="https://facebook.com" target="_blank" rel="noopener noreferrer" className="text-white hover:text-doctor-primary transition-colors">
              <FaFacebook size={24} />
            </Link>
            <Link href="https://youtube.com" target="_blank" rel="noopener noreferrer" className="text-white hover:text-doctor-primary transition-colors">
              <FaYoutube size={24} />
            </Link>
            <Link href="https://instagram.com" target="_blank" rel="noopener noreferrer" className="text-white hover:text-doctor-primary transition-colors">
              <FaInstagram size={24} />
            </Link>
          </div>
          <p className="flex items-center gap-2 mb-2">
            <FaPhoneAlt />
            <Link href="tel:+18003888090" className="hover:text-doctor-primary transition-colors">
              +18003888090
            </Link>
          </p>
          <p className="flex items-center gap-2 mb-2">
            <FaEnvelope />
            <Link href="mailto:dr[username]@gmail.com" className="hover:text-doctor-primary transition-colors">
              dr[username]@gmail.com
            </Link>
          </p>
          <p className="flex items-start gap-2">
            <FaMapMarkerAlt className="mt-1" />
            123 شارع الرئيسي، المركز الطبي، المدينة
          </p>
        </div>
      </div>

      {/* Inline Animation Styles */}
      <style jsx>{`
        @keyframes fadeIn {
          from {
            opacity: 0;
            transform: translateY(20px);
          }
          to {
            opacity: 1;
            transform: translateY(0);
          }
        }
        .animate-fadeIn {
          animation: fadeIn 0.5s ease-in-out forwards;
        }
        .footer-item {
          opacity: 0;
        }
      `}</style>
    </footer>
  );
};

export default PublicFooter;
