'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';
import React from 'react';
import { FaImages, FaListAlt, FaPhoneAlt, FaPhotoVideo, FaQuestionCircle, FaUserMd } from 'react-icons/fa';
import { MdArticle } from 'react-icons/md';
import { RiInstagramLine } from 'react-icons/ri';

const PrivateSidebar = ({ isOpen, isLgScreen, onClose }: { isOpen: boolean; isLgScreen: boolean; onClose: () => void }) => {
  const pathname = usePathname();
  const sidebarWidth = 'w-[14rem]';

  const menuItems = [
    {
      href: '/dashboard/user',
      label: 'الملف الشخصي',
      icon: <FaUserMd />,
    },
    {
      href: '/dashboard/accounts',
      label: 'السوشيال ميديا',
      icon: <RiInstagramLine />,
    },
    {
      href: '/dashboard/media',
      label: 'الميديا و الوسائط',
      icon: <FaPhotoVideo />,
    },
    {
      href: '/dashboard/faq',
      label: 'الاسئلة الشائعة',
      icon: <FaQuestionCircle />,
    },
    {
      href: '/dashboard/carousels',
      label: 'الصور الرئيسية',
      icon: <FaImages />,
    },
    {
      href: '/dashboard/workplaces',
      label: 'أماكن العمل',
      icon: <FaPhoneAlt />,
    },
    {
      href: '/dashboard/categories',
      label: 'الأقسام الطبية',
      icon: <FaListAlt />,
    },
    {
      href: '/dashboard/posts',
      label: 'المقالات',
      icon: <MdArticle />,
    },
  ];

  return (
    <>
      {/* Backdrop for smaller screens */}
      {!isLgScreen && isOpen && <div onClick={onClose} className="fixed inset-0 bg-black opacity-40 transition z-40" />}

      {/* Sidebar */}
      <aside
        className={`h-[calc(100vh-3.5rem)] bg-gray-100 transform transition-transform duration-300 ease-in-out z-50 overflow-y-auto fixed top-14 ${sidebarWidth} right-0 ${
          isLgScreen ? '' : isOpen ? 'translate-x-0' : 'translate-x-full'
        }`}
      >
        <nav className="p-3 space-y-2">
          {menuItems.map((item, index) => (
            <SidebarLink
              key={index}
              onClose={onClose}
              href={item.href}
              label={item.label}
              icon={item.icon}
              isOpen={isOpen || isLgScreen}
              isActive={pathname.startsWith(item.href)}
            />
          ))}
        </nav>
      </aside>
    </>
  );
};

const SidebarLink = ({
  href,
  label,
  icon,
  isOpen,
  isActive,
  onClose,
}: {
  href: string;
  label: string;
  icon: React.ReactNode;
  isOpen: boolean;
  isActive: boolean;
  onClose: () => void;
}) => {
  return (
    <Link
      href={href}
      onClick={onClose}
      dir="rtl"
      className={
        'flex items-center gap-3 py-2 px-4 rounded-md transition-all duration-200 font-medium text-sm ' +
        (isActive
          ? 'bg-doctor-dark text-white' // Active style with pale background and primary text
          : 'text-gray-800 hover:bg-doctor-light') +
        ' hover:shadow-sm active:bg-gray-300 group ' +
        (isOpen ? 'justify-start' : 'justify-center')
      }
    >
      <div
        className={
          'transition-colors duration-200 ' +
          (isActive
            ? 'text-white' // Active icon style
            : 'text-gray-500 group-hover:text-doctor-dark')
        }
      >
        {icon}
      </div>
      {isOpen && <span className={isActive ? 'text-white' : 'text-gray-800 group-hover:text-doctor-dark'}>{label}</span>}
    </Link>
  );
};

export default PrivateSidebar;
