'use client';

import React, { useState } from 'react';
import { FaBars, FaTimes, FaSignOutAlt } from 'react-icons/fa';
import Link from 'next/link';
import Cookies from 'js-cookie';
import { useQuery } from '@tanstack/react-query';
import { getUserDetails } from '@/app/(private)/dashboard/user/user.service';
import Image from 'next/image';

const PrivateHeader = ({ isSidebarOpen, onSidebarToggle, isLgScreen }: { isSidebarOpen: boolean; isLgScreen: boolean; onSidebarToggle: () => void }) => {
  const [isLogoutModalOpen, setIsLogoutModalOpen] = useState(false);

  // Fetch user details using React Query
  const { data: userResponse, isLoading } = useQuery({
    queryKey: ['user'],
    queryFn: getUserDetails,
  });

  const logo = (userResponse?.data?.logo && userResponse?.data?.logo[0]?.url) || '/logo.svg';

  const handleLogout = () => {
    setIsLogoutModalOpen(true); // Show the confirmation modal
  };

  const confirmLogout = () => {
    Cookies.remove('dr_auth_token');
    window.location.href = '/login';
  };

  const cancelLogout = () => {
    setIsLogoutModalOpen(false); // Close the modal
  };

  return (
    <>
      <header className="fixed bg-doctor-dark w-full z-50 my-auto h-14 flex items-center justify-between px-4" dir="rtl">
        {/* Left Section */}
        <div className="flex items-center gap-4">
          {isLoading ? (
            <span className="text-white text-sm sm:text-base">جارٍ التحميل...</span>
          ) : (
            <div className="flex items-center bg-white rounded-full p-1">
              <Link href="/" className="flex items-center">
                <Image src={logo} alt={`Logo`} height={200} width={200} className="w-10 h-10 object-contain" />
              </Link>
            </div>
          )}
        </div>

        {/* Right Section */}
        <div className="flex items-center gap-4">
          {/* Logout Button */}
          <button onClick={handleLogout} className="text-white hover:text-doctor-pale cursor-pointer transition-colors p-1" aria-label="تسجيل الخروج">
            <FaSignOutAlt size={20} />
          </button>

          {/* Sidebar Toggle Button */}
          {!isLgScreen && (
            <button onClick={onSidebarToggle} className="p-2 rounded-full text-white hover:bg-doctor-dark focus:outline-none">
              {isSidebarOpen ? <FaTimes className="text-xl" /> : <FaBars className="text-xl" />}
            </button>
          )}
        </div>
      </header>

      {/* Logout Confirmation Modal */}
      {isLogoutModalOpen && (
        <div className="fixed inset-0 flex items-center justify-center z-50">
          {/* Overlay */}
          <div className="absolute inset-0 bg-black opacity-50" onClick={cancelLogout} />

          {/* Modal */}
          <div className="relative bg-white p-6 sm:p-8 rounded-xl w-full max-w-sm shadow-2xl transform transition-all duration-300 scale-100">
            <h3 className="text-lg sm:text-xl font-bold mb-4 text-doctor-dark text-center">تأكيد تسجيل الخروج</h3>
            <p className="text-gray-700 text-sm sm:text-base mb-6 text-center">هل أنت متأكد أنك تريد تسجيل الخروج؟</p>
            <div className="flex gap-3">
              <button
                onClick={confirmLogout}
                className="flex-1 px-4 py-2 bg-doctor-dark text-white rounded-lg hover:bg-doctor-primary transition-colors duration-200 text-sm sm:text-base"
              >
                نعم
              </button>
              <button
                onClick={cancelLogout}
                className="flex-1 px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400 transition-colors duration-200 text-sm sm:text-base"
              >
                لا
              </button>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default PrivateHeader;
