'use client';

import { useEffect, useState } from 'react';
import PrivateSidebar from '@/shared/components/layout/private/Sidebar';
import PrivateHeader from '@/shared/components/layout/private/Header';

const DashboardLayout = ({ children }: { children: React.ReactNode }) => {
  const [isSidebarOpen, setIsSidebarOpen] = useState(false);
  const [isLgScreen, setIsLgScreen] = useState(false);

  const handleSidebarToggle = () => {
    setIsSidebarOpen((prev) => !prev);
  };

  useEffect(() => {
    const handleResize = () => {
      setIsLgScreen(window.innerWidth >= 1024);
    };

    handleResize();
    window.addEventListener('resize', handleResize);
    return () => window.removeEventListener('resize', handleResize);
  }, []);

  useEffect(() => {
    if (isLgScreen) {
      setIsSidebarOpen(true);
    } else {
      setIsSidebarOpen(false);
    }
  }, [isLgScreen]);

  return (
    <div className="flex flex-col min-h-screen">
      <PrivateHeader isLgScreen={isLgScreen} isSidebarOpen={isSidebarOpen} onSidebarToggle={handleSidebarToggle} />
      <div className="flex-1 pt-14">
        <div className="flex">
          <PrivateSidebar isOpen={isSidebarOpen} isLgScreen={isLgScreen} onClose={() => setIsSidebarOpen(false)} />
          <main className={`flex-1 transition-all p-3 bg-gray-100 ${isLgScreen ? 'lg:mr-[14rem]' : ''}`}>
            <div className="min-h-[calc(100vh-3.425rem)] bg-white rounded-xl p-4 overflow-y-auto">{children}</div>
          </main>
        </div>
      </div>
    </div>
  );
};

export default DashboardLayout;
