import Link from 'next/link';

export default function NotFound() {
  return (
    <div className="flex items-center justify-center min-h-[calc(100vh-132px)] text-center">
      <div className="max-w-lg">
        <h2 className="text-4xl font-bold text-doctor-primary mb-4">404 - الصفحة غير موجودة</h2>
        <p className="text-lg text-gray-500 mb-6">عذرًا! الصفحة التي تبحث عنها قد تم نقلها أو لا وجود لها.</p>
        <Link href="/" className="inline-block bg-doctor-primary text-white hover:bg-doctor-secondary px-6 py-3 rounded-md font-semibold transition-all">
          العودة إلى الرئيسية
        </Link>
      </div>
    </div>
  );
}
