import { LoginFormValues } from './login.schema';

export const login = async (data: LoginFormValues) => {
  const response = await fetch(`${process.env.NEXT_PUBLIC_SERVER_URL}/user/login`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify(data), // Data now includes { email, password }
  });

  const result = await response.json();

  if (!response.ok) {
    throw result;
  }

  return result;
};
