import { zodResolver } from '@hookform/resolvers/zod';
import { useForm } from 'react-hook-form';
import * as z from 'zod';

// Define the validation schema with Arabic error messages
const loginSchema = z.object({
  email: z.string().email({ message: 'البريد الإلكتروني غير صالح' }),
  password: z.string().min(5, { message: 'يجب أن تكون كلمة المرور 5 أحرف على الأقل' }),
});

// Infer the TypeScript type from the schema
export type LoginFormValues = z.infer<typeof loginSchema>;

// Custom hook to use the form with zod
export const useLoginForm = () => {
  return useForm<LoginFormValues>({
    resolver: zodResolver(loginSchema),
    defaultValues: {
      email: '',
      password: '',
    },
  });
};

export default loginSchema;
