import React from 'react';
import Image from 'next/image';
import { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'الرؤية والرسالة',
};

const Vision: React.FC = () => {
  return (
    <section className="py-12 bg-white border border-neutral-200 rounded-lg">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Full-Width Image */}
        <div className="relative w-full h-64 md:h-96 lg:h-[500px] mb-8">
          <Image src="/vision.webp" alt="مركز العمود الفقري" fill className="object-cover rounded-lg" priority />
        </div>

        {/* Welcome Section */}
        <div className="py-8">
          <h2 className="text-2xl md:text-3xl font-bold font-heading text-doctor-primary mb-6">ترحيب</h2>
          <p className="text-gray-600 text-lg font-body">
            مرحبًا بكم في مركز العمود الفقري، حيث نلتزم بتقديم أفضل الخدمات الطبية المتخصصة لعلاج مشاكل العمود الفقري باستخدام أحدث التقنيات. نحن هنا لدعمكم في رحلة الشفاء بكل
            احترافية ورعاية.
          </p>
        </div>

        {/* History Section */}
        <div className="py-8">
          <h2 className="text-2xl md:text-3xl font-bold font-heading text-doctor-primary mb-4">تاريخ إنشاء مركز العمود الفقري</h2>
          <p className="text-gray-600 text-base font-body">
            تأسس مركز العمود الفقري في عام 2010 بهدف تقديم رعاية طبية متخصصة للمرضى الذين يعانون من مشاكل العمود الفقري. منذ ذلك الحين، ونحن نسعى لتحقيق التميز في الخدمات الطبية من
            خلال فريق من الأطباء ذوي الخبرة العالية واستخدام أحدث التقنيات الطبية لضمان أفضل النتائج لمرضانا.
          </p>
        </div>

        {/* Vision Section */}
        <div className="py-8">
          <h2 className="text-2xl md:text-3xl font-bold font-heading text-doctor-primary mb-4">رؤيتنا</h2>
          <p className="text-gray-600 text-base font-body">
            أن نكون المركز الرائد في علاج مشاكل العمود الفقري على مستوى المنطقة، من خلال تقديم حلول طبية مبتكرة وشاملة تركز على تحسين جودة حياة المرضى باستخدام أحدث التقنيات
            والمعايير العالمية.
          </p>
        </div>

        {/* Mission Section */}
        <div className="py-8">
          <h2 className="text-2xl md:text-3xl font-bold font-heading text-doctor-primary mb-4">رسالتنا</h2>
          <p className="text-gray-600 text-base font-body">
            تقديم رعاية صحية متميزة وشخصية لكل مريض، مع التركيز على الدقة في التشخيص والعلاج، وتوفير بيئة داعمة تساعد المرضى على التعافي بسرعة وأمان، مع الحفاظ على أعلى معايير
            الجودة والأخلاق الطبية.
          </p>
        </div>
      </div>
    </section>
  );
};

export default Vision;
