import { Media, ListMediaFilter } from '@/app/(private)/dashboard/media/media.schema'; // Adjust path
import MediaVideosClient from './MediaVideosClient';
import { Metadata } from 'next';

// Fetch media with ISR
async function fetchMedia(filter: ListMediaFilter, type?: string): Promise<{ data: Media[]; totalItems: number }> {
  const queryParams = new URLSearchParams({
    page: filter.page.toString(),
    pageSize: filter.pageSize.toString(),
    ...(type && { type }),
  });

  const response = await fetch(`${process.env.NEXT_PUBLIC_SERVER_URL}/media/list?${queryParams.toString()}`, {
    next: { revalidate: 30 }, // Revalidate every 30 seconds
  });
  if (!response.ok) {
    throw new Error('Failed to fetch media items');
  }
  const result = await response.json();
  return {
    data: result.data,
    totalItems: result.pagination.totalItemsCount,
  };
}

export const metadata: Metadata = {
  title: 'الميديا',
};

export default async function MediaPage() {
  const initialFilter: ListMediaFilter = { page: 1, pageSize: 10 }; // Default filter
  try {
    const { data: mediaItems, totalItems } = await fetchMedia(initialFilter);

    return (
      <section className="py-12 bg-white border border-neutral-200 rounded-lg min-h-screen" dir="rtl">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          {/* Header */}
          <div className="mb-12 animate-fadeIn">
            <h1 className="text-3xl md:text-4xl font-bold font-heading text-doctor-primary mb-2">الميديــــــــــــا</h1>
            <p className="text-lg text-gray-600 font-body">استكشف مجموعة من الفيديوهات التي توضح خدماتي وإجراءات الأشعة التداخلية.</p>
          </div>
          {/* Pass initial data to client component */}
          <MediaVideosClient initialMedia={mediaItems} initialTotalItems={totalItems} initialFilter={initialFilter} />
        </div>
      </section>
    );
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
  } catch (error) {
    return (
      <section className="py-12 bg-white border border-neutral-200 rounded-lg min-h-screen" dir="rtl">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <h1 className="text-3xl md:text-4xl font-bold font-heading text-doctor-primary mb-2">الميديــــــــــــا</h1>
          <p className="text-center text-red-500">حدث خطأ أثناء جلب البيانات. حاول مرة أخرى لاحقًا.</p>
        </div>
      </section>
    );
  }
}
