import PublicHeader from '@/shared/components/layout/public/Header';
import React from 'react';
import ContactForm from './(home)/sections/ContactForm';
import DepartmentsAside from './(home)/sections/DepartmentsAside';
import ReviewForm from './(home)/sections/ReviewForm';

const PublicLayout = ({ children }: { children: React.ReactNode }) => {
  return (
    <>
      <PublicHeader />
      <main>
        <div className="min-h-screen bg-gray-50">
          {/* Main Content with Aside */}
          <div className="px-4 sm:px-6 lg:px-8 py-12">
            <div className="max-w-[85rem] mx-auto">
              <div className="flex flex-col lg:flex-row gap-8">
                {/* Departments Aside */}
                <aside className="lg:w-[340px] w-full lg:top-4 h-fit flex flex-col gap-8">
                  <DepartmentsAside />
                  <ContactForm />
                  <ReviewForm />

                </aside>

                {/* Hero and About Section */}
                <div className="w-full lg:w-[calc(100%-340px-2rem)] flex flex-col gap-8">{children}</div>
              </div>
            </div>
          </div>
        </div>
      </main>
    </>
  );
};

export default PublicLayout;
