import { FAQ } from '@/app/(private)/dashboard/faq/faq.schema';
import FAQAccordion from './FAQAccordion';
import { Metadata } from 'next';

// Fetch FAQs with ISR
async function fetchFAQs(): Promise<FAQ[]> {
  const response = await fetch(`${process.env.NEXT_PUBLIC_SERVER_URL}/faq/list`, {
    next: { revalidate: 30 }, // Revalidate every 30 seconds
  });
  if (!response.ok) {
    throw new Error('Failed to fetch FAQs');
  }
  return response.json();
}
export const metadata: Metadata = {
  title: 'الأسئلة الشائعة',
};

export default async function FAQPage() {
  try {
    const faqs = await fetchFAQs();

    return (
      <section className="py-12 bg-white border border-neutral-200 rounded-lg min-h-screen" dir="rtl">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          {/* Section Title */}
          <h2 className="text-2xl md:text-3xl font-bold font-heading text-doctor-primary mb-6">الأسئلة الشائعة</h2>
          <p className="mb-8 text-base text-gray-500 font-body max-w-2xl md:mb-12">تجد هنا إجابات لأكثر الأسئلة شيوعًا حول الأشعة التداخلية والإجراءات التي أقدمها.</p>
          {/* Pass FAQs to the client component */}
          <FAQAccordion faqs={faqs.filter((faq) => faq.is_active)} />
        </div>
      </section>
    );
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
  } catch (error) {
    return (
      <section className="py-12 bg-white border border-neutral-200 rounded-lg min-h-screen" dir="rtl">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <h2 className="text-2xl md:text-3xl font-bold font-heading text-doctor-primary mb-6">الأسئلة الشائعة</h2>
          <p className="text-center text-red-500">حدث خطأ أثناء جلب البيانات. حاول مرة أخرى لاحقًا.</p>
        </div>
      </section>
    );
  }
}
