'use client';

import React, { useState } from 'react';
import { FaChevronDown, FaChevronUp } from 'react-icons/fa';
import { FAQ } from '@/app/(private)/dashboard/faq/faq.schema'; // Adjust path

interface FAQAccordionProps {
  faqs: FAQ[];
}

const FAQAccordion: React.FC<FAQAccordionProps> = ({ faqs }) => {
  const [openIndex, setOpenIndex] = useState<number | null>(null);

  const toggleFAQ = (index: number) => {
    setOpenIndex(openIndex === index ? null : index);
  };

  return (
    <div className="space-y-4">
      {faqs.length > 0 ? (
        faqs.map((faq, index) => (
          <div
            key={faq.id}
            className="border border-gray-200 rounded-lg shadow-sm hover:shadow-md transition-all duration-300 animate-fadeIn"
            style={{ animationDelay: `${index * 0.1}s` }}
          >
            <button onClick={() => toggleFAQ(index)} className="flex justify-between items-center w-full p-4 text-right focus:outline-none">
              <h3 className="text-lg font-semibold text-doctor-dark font-heading">{faq.question}</h3>
              <span className="text-gray-600">{openIndex === index ? <FaChevronUp /> : <FaChevronDown />}</span>
            </button>
            <div
              className={`overflow-hidden transition-all duration-300 ease-in-out ${
                openIndex === index ? 'max-h-96 opacity-100 translate-y-0' : 'max-h-0 opacity-0 -translate-y-2'
              }`}
            >
              <div className="p-4 pt-0 text-gray-600 text-sm md:text-base font-body">
                <p>{faq.answer}</p>
              </div>
            </div>
          </div>
        ))
      ) : (
        <p className="text-center text-gray-600">لا توجد أسئلة شائعة متاحة حاليًا</p>
      )}
      {/* Inline Animation Styles */}
      <style jsx>{`
        @keyframes fadeIn {
          from {
            opacity: 0;
            transform: translateY(20px);
          }
          to {
            opacity: 1;
            transform: translateY(0);
          }
        }
        .animate-fadeIn {
          animation: fadeIn 0.5s ease-in-out;
        }
      `}</style>
    </div>
  );
};

export default FAQAccordion;
