import { Carousel } from '@/app/(private)/dashboard/carousels/carousel.schema';
import HeroCarousel from './HeroCarousel';

// Fetch carousel items with ISR
async function fetchCarouselItems(): Promise<Carousel[]> {
  const response = await fetch(`${process.env.NEXT_PUBLIC_SERVER_URL}/carousel/list`, {
    next: { revalidate: 30 }, // Revalidate every 30 seconds
  });
  if (!response.ok) {
    throw new Error('Failed to fetch carousel items');
  }
  return response.json();
}

export default async function HeroSection() {
  try {
    const carouselItems = await fetchCarouselItems();

    return (
      <section className="hero-section relative w-full h-[600px] overflow-hidden">
        <HeroCarousel slides={carouselItems} />
      </section>
    );
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
  } catch (error) {
    return (
      <section className="hero-section relative w-full h-[600px] overflow-hidden">
        <div className="absolute inset-0 flex items-center justify-center text-red-500">
          <p>حدث خطأ أثناء جلب البيانات. حاول مرة أخرى لاحقًا.</p>
        </div>
      </section>
    );
  }
}
