'use client';

import React, { useState, useEffect } from 'react';
import { Swiper, SwiperSlide } from 'swiper/react';
import { Autoplay, Navigation } from 'swiper/modules';
import Link from 'next/link';
import Image from 'next/image';
import 'swiper/css';
import 'swiper/css/navigation';
import { Carousel } from '@/app/(private)/dashboard/carousels/carousel.schema';

interface HeroCarouselProps {
  slides: Carousel[];
}

const HeroCarousel: React.FC<HeroCarouselProps> = ({ slides }) => {
  const [showNavigation, setShowNavigation] = useState(false);

  // Detect screen size and update navigation state
  useEffect(() => {
    const handleResize = () => {
      setShowNavigation(window.innerWidth >= 768);
    };

    handleResize();
    window.addEventListener('resize', handleResize);

    return () => window.removeEventListener('resize', handleResize);
  }, []);

  return (
    <>
      <Swiper
        modules={[Autoplay, Navigation]}
        spaceBetween={0}
        slidesPerView={1}
        loop={true}
        dir="rtl"
        navigation={showNavigation}
        autoplay={{
          delay: 4000,
          disableOnInteraction: false,
        }}
        className="h-full"
      >
        {slides.length > 0 ? (
          slides.map((slide) => (
            <SwiperSlide key={slide.id}>
              <div className="relative w-full h-full">
                {/* Background Image */}
                <Image width={1000} height={1000} src={slide.img[0]?.url} alt={slide.title} className="w-full h-full object-cover object-center" />
                {/* Overlay */}
                <div className="absolute inset-0 bg-black opacity-60 z-10"></div>
                {/* Content */}
                <div className="absolute inset-0 flex items-center justify-center z-20">
                  <div className="text-center text-white px-4">
                    <h1 className="text-4xl md:text-6xl font-bold mb-4 font-heading text-doctor-primary">{slide.title}</h1>
                    <p className="text-lg md:text-xl max-w-2xl mx-auto font-body text-gray-200">{slide.description}</p>
                    {/* Button (conditionally rendered) */}
                    {slide.button_txt && slide.button_url && (
                      <Link
                        href={slide.button_url}
                        className="mt-6 inline-block bg-doctor-primary text-white px-5 py-2.5 rounded-lg hover:bg-doctor-dark transition-colors font-body text-md font-medium"
                      >
                        {slide.button_txt}
                      </Link>
                    )}
                  </div>
                </div>
              </div>
            </SwiperSlide>
          ))
        ) : (
          <SwiperSlide>
            <div className="relative w-full h-full flex items-center justify-center text-gray-500">
              <p>لا توجد عناصر كاروسيل متاحة حاليًا</p>
            </div>
          </SwiperSlide>
        )}
      </Swiper>

      {/* Inline Styles */}
      <style global jsx>{`
        .hero-section .swiper-button-prev,
        .hero-section .swiper-button-next {
          color: white;
          transition: all 0.3s ease;
          margin-inline: 10px;
        }

        .hero-section .swiper-button-prev:hover,
        .hero-section .swiper-button-next:hover {
          color: #21bace;
        }
      `}</style>
    </>
  );
};

export default HeroCarousel;
