import DepartmentsAsideClient, { Department } from './DepartmentsAsideClient';

// Fetch departments data with ISR
async function fetchDepartments(): Promise<Department[]> {
  const response = await fetch(`${process.env.NEXT_PUBLIC_SERVER_URL}/post/category-posts-list`, {
    next: { revalidate: 60 }, // Revalidate every 60 seconds
  });

  if (!response.ok) {
    throw new Error('Failed to fetch departments data');
  }

  return response.json();
}

export default async function DepartmentsAside() {
  try {
    const departments = await fetchDepartments();

    return (
      <aside className="w-full top-4 h-fit">
        <div className="bg-white p-6 rounded-lg border border-neutral-200">
          <h2 className="text-2xl font-bold text-doctor-dark mb-6 font-heading">الأقسام الطبية</h2>
          {departments.length === 0 ? <p className="text-gray-500 text-sm">لم يتم إضافة أقسام رئيسية بعد</p> : <DepartmentsAsideClient departments={departments} />}
        </div>
      </aside>
    );
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
  } catch (error) {
    return (
      <aside className="w-full top-4 h-fit">
        <div className="bg-white p-6 rounded-lg border border-neutral-200">
          <h2 className="text-2xl font-bold text-doctor-dark mb-6 font-heading">الأقسام الطبية</h2>
          <p className="text-red-500 text-sm">حدث خطأ أثناء جلب البيانات. حاول مرة أخرى لاحقًا.</p>
        </div>
      </aside>
    );
  }
}
