import { z } from 'zod';

// Workplace interface based on backend
export interface Workplace {
  id: number;
  name: string;
  url: string | null;
  address: string;
  phone_1: string;
  phone_2: string | null;
  email: string;
  examine_price: string | null;
  createdAt: string;
  updatedAt: string;
}

// Schema for creating a workplace
export const createWorkplaceFormSchema = z.object({
  name: z.string().min(1, 'الاسم مطلوب').max(256, 'الاسم يجب ألا يتجاوز 256 حرفًا'),
  url: z.string().url('يجب أن يكون الرابط صالحًا').nullable().optional(),
  address: z.string().min(1, 'العنوان مطلوب').max(1000, 'العنوان يجب ألا يتجاوز 1000 حرف'),
  phone_1: z.string().min(1, 'رقم الهاتف الأول مطلوب').max(50, 'رقم الهاتف يجب ألا يتجاوز 50 حرفًا'),
  phone_2: z.string().max(50, 'رقم الهاتف الثاني يجب ألا يتجاوز 50 حرفًا').nullable().optional(),
  email: z.string().email('البريد الإلكتروني غير صالح').min(1, 'البريد الإلكتروني مطلوب').max(256),
  examine_price: z.string().max(50, 'سعر الكشف يجب ألا يتجاوز 50 حرفًا').nullable().optional(),
});

// Schema for updating a workplace
export const updateWorkplaceFormSchema = z.object({
  name: z.string().min(1, 'الاسم مطلوب').max(256, 'الاسم يجب ألا يتجاوز 256 حرفًا'),
  url: z.string().url('يجب أن يكون الرابط صالحًا').nullable().optional(),
  address: z.string().min(1, 'العنوان مطلوب').max(1000, 'العنوان يجب ألا يتجاوز 1000 حرف'),
  phone_1: z.string().min(1, 'رقم الهاتف الأول مطلوب').max(50, 'رقم الهاتف يجب ألا يتجاوز 50 حرفًا'),
  phone_2: z.string().max(50, 'رقم الهاتف الثاني يجب ألا يتجاوز 50 حرفًا').nullable().optional(),
  email: z.string().email('البريد الإلكتروني غير صالح').min(1, 'البريد الإلكتروني مطلوب').max(256),
  examine_price: z.string().max(50, 'سعر الكشف يجب ألا يتجاوز 50 حرفًا').nullable().optional(),
});

// Types
export type CreateWorkplaceFormValues = z.infer<typeof createWorkplaceFormSchema>;
export type UpdateWorkplaceFormValues = z.infer<typeof updateWorkplaceFormSchema>;
