/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable @typescript-eslint/no-unused-vars */
import { z } from 'zod';

export interface Category {
  id: number;
  name: string;
  parent_category_id: number | null;
  index: number;
  is_active: boolean;
  createdAt: string;
  updatedAt: string;
  sub_categories?: Category[];
  parent_category?: Category;
  posts?: any[];
}

const baseCategorySchema = z.object({
  name: z.string().min(1, 'اسم الفئة مطلوب').max(256, 'اسم الفئة يجب ألا يتجاوز 256 حرفًا'),
  parent_category_id: z.number().int().positive().nullable().optional(),
  index: z.number().int().min(0, 'الترتيب يجب أن يكون 0 أو أكبر').optional().default(0),
  is_active: z.boolean().optional().default(true),
});

// Schema for creating any category (main or sub, parent_category_id optional)
export const createCategoryFormSchema = baseCategorySchema;

// Schema specifically for main categories (no parent_category_id)
export const createMainCategoryFormSchema = createCategoryFormSchema.omit({ parent_category_id: true });

// Schema specifically for sub-categories (parent_category_id required)
export const createSubCategoryFormSchema = baseCategorySchema.extend({
  parent_category_id: z
    .number({ invalid_type_error: 'الفئة الأصلية مطلوبة' })
    .int({ message: 'الفئة الأصلية يجب أن تكون عددًا صحيحًا' })
    .positive({ message: 'الفئة الأصلية يجب أن تكون قيمة موجبة' })
    .refine((val) => !isNaN(val), { message: 'الفئة الأصلية مطلوبة' }),
});

// Schema for updating categories (all fields optional)
export const updateCategoryFormSchema = z.object({
  name: z.string().min(1, 'اسم الفئة مطلوب').max(256, 'اسم الفئة يجب ألا يتجاوز 256 حرفًا').optional(),
  index: z.number().int().min(0, 'الترتيب يجب أن يكون 0 أو أكبر').optional(),
  is_active: z.boolean().optional(),
});

export type CreateCategoryFormValues = z.infer<typeof createCategoryFormSchema>;
export type CreateSubCategoryFormValues = z.infer<typeof createSubCategoryFormSchema>;
export type UpdateCategoryFormValues = z.infer<typeof updateCategoryFormSchema>;

export const deleteCategoriesSchema = z.object({
  ids: z.array(z.number().int().positive().min(1)).optional(),
});

export type DeleteCategoriesData = z.infer<typeof deleteCategoriesSchema>;
