import { z } from 'zod';

// FileMetadata for img
export interface FileMetadata {
  url: string;
  filename: string;
}

// Carousel interface based on backend
export interface Carousel {
  id: number;
  title: string;
  description: string;
  img: FileMetadata[];
  button_txt: string | null;
  button_url: string | null;
  createdAt: string;
  updatedAt: string;
}

// Schema for creating a carousel item
export const createCarouselFormSchema = z.object({
  title: z.string().min(1, 'العنوان مطلوب').max(256, 'العنوان يجب ألا يتجاوز 256 حرفًا'),
  description: z.string().min(1, 'الوصف مطلوب').max(1000, 'الوصف يجب ألا يتجاوز 1000 حرف'),
  img: z.array(z.object({ url: z.string(), filename: z.string() })).min(1, 'الصورة مطلوبة'),
  button_txt: z.string().max(100, 'نص الزر يجب ألا يتجاوز 100 حرف').nullable().optional(),
  button_url: z.string().url('يجب أن يكون الرابط صالحًا').nullable().optional(),
});

// Schema for updating a carousel item
export const updateCarouselFormSchema = z.object({
  title: z.string().min(1, 'العنوان مطلوب').max(256, 'العنوان يجب ألا يتجاوز 256 حرفًا'),
  description: z.string().min(1, 'الوصف مطلوب').max(1000, 'الوصف يجب ألا يتجاوز 1000 حرف'),
  img: z.array(z.object({ url: z.string(), filename: z.string() })).min(1, 'الصورة مطلوبة'),
  button_txt: z.string().max(100, 'نص الزر يجب ألا يتجاوز 100 حرف').nullable().optional(),
  button_url: z.string().url('يجب أن يكون الرابط صالحًا').nullable().optional(),
});

// Types
export type CreateCarouselFormValues = z.infer<typeof createCarouselFormSchema>;
export type UpdateCarouselFormValues = z.infer<typeof updateCarouselFormSchema>;
