import { z } from 'zod';

// Define the Account type based on the updated backend schema
export interface Account {
  id: number;
  icon: string; // Not nullable in the migration
  url: string; // Not nullable in the migration
  is_active: boolean;
  createdAt: string;
  updatedAt: string;
}

// Schema for updating an account (only url and is_active)
export const updateAccountFormSchema = z.object({
  url: z.string().min(1, 'الرابط مطلوب').max(10000, 'الرابط يجب ألا يتجاوز 10000 حرف'),
  is_active: z.boolean().optional(),
});

export type UpdateAccountFormValues = z.infer<typeof updateAccountFormSchema>;
