import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import React from 'react';
import { renderToReadableStream } from 'react-dom/server.edge';
import { ServerInsertedMetadataContext } from '../../../shared/lib/server-inserted-metadata.shared-runtime';
import { renderToString } from '../render-to-string';
export function createServerInsertedMetadata() {
    let metadataResolver = null;
    let metadataToFlush = null;
    const setMetadataResolver = (resolver)=>{
        metadataResolver = resolver;
    };
    return {
        ServerInsertedMetadataProvider: ({ children })=>{
            return /*#__PURE__*/ _jsx(ServerInsertedMetadataContext.Provider, {
                value: setMetadataResolver,
                children: children
            });
        },
        async getServerInsertedMetadata () {
            if (!metadataResolver || metadataToFlush) {
                return '';
            }
            metadataToFlush = metadataResolver();
            const html = await renderToString({
                renderToReadableStream,
                element: /*#__PURE__*/ _jsx(_Fragment, {
                    children: metadataToFlush
                })
            });
            return html;
        }
    };
}

//# sourceMappingURL=create-server-inserted-metadata.js.map